function A1=inverz(A)
%funkcija za resavanje sistema A*xi=ei 
%gde je xi vektor i-te kolone matrice A1(inverzne matrice A)
%a ei koordinatni vektor (A*A1=I)

n = size(A,1);

A1=zeros(n);
promena=[];

%brv-broj vektora
for brv=1:n
    B=A;
% postavljanje pocetnog redosleda indeksa nepoznatih
  for i=1:n
    promena(1,i)=i;
  end
% dodavanje ei koordinatnog vektora
  for i=1:n
    if i==brv
      B(i,n+1)=1;
    else
      B(i,n+1)=0;
    end
  end

  for i=1:n-1
    [a,b]=pivot(B,i,n);
% ne vrsimo zamenu ako je pivot na odgovarajucem mestu
    if (a~=i) | (b~=i)    
      B=zameni(B,i,a,b);
      promena(1,:)=zamenaKolona(promena(1,:), i, b);
    end

    for k=i+1:n
      mk=B(k,i)./B(i,i);
      for j=i:n+1
        B(k,j)=B(k,j)-B(i,j).*mk;
      end
    end
  end
  A1(:,brv)=kol_nep(B, promena, n);
end


% Nalazenje pivota

function [v,k]=pivot(A,p,d)
  max=abs(A(p,p));
  v=p;
  k=p;

  for i=p:d
    for j=p:d
      if abs(A(i,j))>max
        v=i;
        k=j;
        max=abs(A(i,j));
      end
    end
  end

%Zamna v-vrste i k-kolone sa p-vrstom i p-kolonom

function M=zameni(A,p,v,k)
  M=A;
  if k~=1
    kT=M(:,p);  
    M(:,p)=M(:,k);
    M(:,k)=kT;
  end
  if v~=1
   vT=M(p,:);
   M(p,:)=M(v,:);
   M(v,:)=vT;
  end

% zamena a-kolone sa b-kolonom

function M=zamenaKolona(K,a,b)
  M=K;
  t=M(1,a);
  M(1,a)=M(1,b);
  M(1,b)=t;

% Izracunavanje kolone nepoznatih
% A - prosirena matrica, P - Kolona premestanja, d - dimenzija matrice 

function M=kol_nep(A,P,d)
  X=zeros(1,d);
  M=zeros(d,1);
  X(1,d)=A(d,d+1)./A(d,d);
  for i=d-1:-1:1
    Z=0;
    for j=d:-1:i+1
      Z=Z+X(1,j).*A(i,j);
    end
    X(1,i)=(A(i,d+1)-Z)./A(i,i);
  end

  for i=1:d
    M(P(1,i),1)=X(1,i);
  end

